from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from app.v1.models.platform.applinks import AppLinks
from app.v1.services.platform import applinks as applinks_service

router = APIRouter()

@router.get("/", response_model=AppLinks)
def get_settings(db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return applinks_service.get_applinks_settings(db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

@router.post("/{account_id}", response_model=AppLinks)
def update_settings(account_id: str, settings: AppLinks, db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return applinks_service.update_applinks_settings(account_id,settings.dict(), db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))
